<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Customer extends CI_Controller
{
    private $auth;

    public function __construct()
    {
        parent::__construct();
        $this->auth = $this->cms_authentication->check();
    }

    public function index()
    {
        if ($this->auth == null || !in_array(4, $this->auth['group_permission']))
            $this->cms_common_string->cms_redirect(CMS_BASE_URL . 'backend');

        $data['seo']['title'] = "Phần mềm quản lý bán hàng";
        $data['user'] = $this->auth;
        $data['template'] = 'customer/index';
        $store = $this->db->from('stores')->get()->result_array();
        $data['data']['store'] = $store; 
        
        $store_id = $this->db->select('store_id')->from('users')->where('id', $this->auth['id'])->limit(1)->get()->row_array();
        $data['data']['store_id'] = $store_id['store_id'];
        
        $this->load->view('layout/index', isset($data) ? $data : null);
    }

    public function cms_paging_order_by_customer_id($page = 1)
    {
        $option = $this->input->post('data');
        $config = $this->cms_common->cms_pagination_custom();

        $total_orders = $this->db
            ->select('count(ID) as quantity, sum(total_money) as total_money, sum(lack) as total_debt')
            ->from('orders')
            ->where('deleted', 0)
            ->where('customer_id', $option['customer_id'])
            ->get()
            ->row_array();
        $data['_list_orders'] = $this->db
            ->from('orders')
            ->limit($config['per_page'], ($page - 1) * $config['per_page'])
            ->order_by('created', 'desc')
            ->where('deleted', 0)
            ->where('customer_id', $option['customer_id'])
            ->get()
            ->result_array();

        $data['_list_customer'] = $this->cms_common->unique_multidim_array($data['_list_orders'], 'customer_id');
        $data['customer_id'] = $option['customer_id'];
        $config['base_url'] = 'cms_paging_order_by_customer_id';
        $config['total_rows'] = $total_orders['quantity'];
        $config['per_page'] = 10;
        $this->pagination->initialize($config);
        $_pagination_link = $this->pagination->create_links();
        $data['total_orders'] = $total_orders;
        if ($page > 1 && ($total_orders['quantity'] - 1) / ($page - 1) == 10)
            $page = $page - 1;

        $data['page'] = $page;
        $data['_pagination_link'] = $_pagination_link;
        $this->load->view('ajax/customer-supplier/list_orders', isset($data) ? $data : null);
    }

    public function cms_paging_order_debt_by_customer_id($page = 1)
    {
        $option = $this->input->post('data');
        $config = $this->cms_common->cms_pagination_custom();
        $config['per_page'] = 100;

        $total_orders = $this->db
            ->select('count(ID) as quantity, sum(total_money) as total_money, sum(lack) as total_debt')
            ->from('orders')
            ->where(['deleted'=> 0,'order_status'=>1])
            ->where(['customer_id'=> $option['customer_id'],'lack >'=>0])
            ->get()
            ->row_array();
        $data['_list_orders'] = $this->db
            ->from('orders')
            ->limit($config['per_page'], ($page - 1) * $config['per_page'])
            ->order_by('created', 'asc')
            ->where(['deleted'=> 0,'order_status'=>1])
            ->where(['customer_id'=> $option['customer_id'],'lack >'=>0])
            ->get()
            ->result_array();

        $data['_list_customer'] = $this->cms_common->unique_multidim_array($data['_list_orders'], 'customer_id');
        $data['customer_id'] = $option['customer_id'];
        $config['base_url'] = 'cms_paging_order_debt_by_customer_id';
        $config['total_rows'] = $total_orders['quantity'];
        $this->pagination->initialize($config);
        $_pagination_link = $this->pagination->create_links();
        $data['total_orders'] = $total_orders;
        if ($page > 1 && ($total_orders['quantity'] - 1) / ($page - 1) == 10)
            $page = $page - 1;

        $data['page'] = $page;
        $data['_pagination_link'] = $_pagination_link;
        $this->load->view('ajax/customer-supplier/list_orders_debt', isset($data) ? $data : null);
    }

    public function fillter()
    {

        $option = $this->input->post('data');
        if ($option['option'] == '1') {
            $this->db->where('diemtichluy > 0');
        }else if ($option['option'] == '2') {
            $this->db->join('orders', 'orders.customer_id=customers.ID and cms_orders.deleted=0', 'LEFT');
            $this->db->where('lack >',0);
            $this->db->having('sum(lack) > 0');
        }

        if ($option['keyword']!='') {
            $this->db->where("(customer_code LIKE '%" . $option['keyword'] . "%' OR customer_name LIKE '%" . $option['keyword'] . "%' OR customer_phone LIKE '%" . $option['keyword'] . "%')", NULL, FALSE);
        }
        $this->db->where('customers.kho_id',$this->auth['store_id']);

    }
    public function cms_paging_listcustomer($page = 1)
    {
        $config = $this->cms_common->cms_pagination_custom();
        $option = $this->input->post('data');
        $store_id_v = $this->db->select('store_id')->from('users')->where('id', $this->auth['id'])->limit(1)->get()->row_array();
        $store_id = $store_id_v['store_id'];

        if ($option['option'] == 0) {
            $this->db
               ->from('customers');
            $this->fillter();   
            $total_customer = $this->db->get()->row_array();

             $this->db
                ->select('customers.ID')
                ->from('customers');
            $this->fillter();
            $temp =$this->db->group_by('customers.ID')->get()->result_array();

            $total_customer['quantity'] = count($temp);
            $this->db
                ->select('customers.ID,customer_group,customer_code,customer_image,customer_name,customer_phone,customer_addr,diemtichluy,kho_id')
                ->from('customers');

            $this->fillter();                
            $data['_list_customer'] = $this->db->limit($config['per_page'], ($page - 1) * $config['per_page'])
                ->order_by('customers.created', 'desc')
                ->group_by('customers.ID')
                ->get()
                ->result_array();

        } else if ($option['option'] == 1) {
            $this->db
                ->from('customers');
            $this->fillter();  
            $total_customer = $this->db->get()->row_array();

            $temp = $this->db
                ->select('customers.ID')
                ->from('customers');
            $this->fillter();      
            $temp = $this->db->group_by('customers.ID')->get()->result_array();

            $total_customer['quantity'] = count($temp);
			$this->db
                ->select('customers.ID,customer_group,customer_code,customer_image,customer_name,customer_phone,customer_addr,diemtichluy,kho_id')
                ->from('customers');                
            $this->fillter();  

            $data['_list_customer'] = $this->db->limit($config['per_page'], ($page - 1) * $config['per_page'])
                ->order_by('customers.diemtichluy', 'desc')
                ->group_by('customers.ID')
                ->get()
                ->result_array();
        } else {
             $this->db
                ->from('customers');
            $this->fillter(); 
            $total_customer =$this->db->get()->row_array();

            $this->db
                ->select('customers.ID')
                ->from('customers');
            $this->fillter();                 
            $temp = $this->db->get()->result_array();
            $total_customer['quantity'] = count($temp);

            $this->db
                ->select('customers.ID,customer_group,customer_image,customer_code,customer_name,customer_phone,customer_addr,diemtichluy,kho_id')
                ->from('customers');
            $this->fillter();    

            $data['_list_customer'] = $this->db->limit($config['per_page'], ($page - 1) * $config['per_page'])
                ->order_by('lack', 'desc')
                ->group_by('customers.ID')
                ->get()
                ->result_array();
        }

        $config['base_url'] = 'cms_paging_listcustomer';
        $config['per_page'] = 10;
        $config['total_rows'] = isset($total_customer['quantity']) ? $total_customer['quantity'] : 0;
        $this->pagination->initialize($config);
        $_pagination_link = $this->pagination->create_links();
        $data['_total_customer'] = $total_customer;
        $data['_pagination_link'] = $_pagination_link;
        $data['user'] = $this->auth;
        if ($page > 1 && ($total_customer['quantity'] - 1) / ($page - 1) == 10)
            $page = $page - 1;

        $data['option'] = $option['option'];
        $data['page'] = $page;
        $this->load->view('ajax/customer-supplier/list_customer', isset($data) ? $data : null);
    }

    public function cms_detail_customer($id)
    {
        $id = (int)$id;
        $cus = $this->db->from('customers')->where('ID', $id)->get()->row_array();
        if (!isset($cus) && count($cus) == 0) {
            echo $this->messages;
            return;
        } else {
            $data['_list_cus'] = $cus;
            $data['customer_id'] = $id;
            $store = $this->db->from('stores')->get()->result_array();
            $data['data']['store'] = $store;
            
            $store_id = $this->db->select('store_id')->from('users')->where('id', $this->auth['id'])->limit(1)->get()->row_array();
            $data['data']['store_id'] = $store_id['store_id'];
            
            $this->load->view('ajax/customer-supplier/detail_cus', isset($data) ? $data : null);
        }
    }

    public function cms_crcustomer($total_debt)
    {
        $data = $this->input->post('data');
        $data = $this->cms_common_string->allow_post($data, ['customer_group','customer_code', 'customer_name', 'customer_phone', 'customer_email', 'customer_addr', 'notes','customer_image', 'customer_birthday', 'customer_gender','kho_id']);
        $data['customer_birthday'] = gmdate("Y-m-d H:i:s", strtotime(str_replace('/', '-', $data['customer_birthday'])) + 7 * 3600);
        $data['created'] = gmdate("Y:m:d H:i:s", time() + 7 * 3600);
        $data['user_init'] = $this->auth['id'];
        if ($data['customer_code'] == '') {
            $this->db->select_max('customer_code')->like('customer_code', 'KH');
            $max_customer_code = $this->db->get('customers')->row();
            $max_code = (int)(str_replace('KH', '', $max_customer_code->customer_code)) + 1;
            if ($max_code < 10)
                $data['customer_code'] = 'KH00000' . ($max_code);
            else if ($max_code < 100)
                $data['customer_code'] = 'KH0000' . ($max_code);
            else if ($max_code < 1000)
                $data['customer_code'] = 'KH000' . ($max_code);
            else if ($max_code < 10000)
                $data['customer_code'] = 'KH00' . ($max_code);
            else if ($max_code < 100000)
                $data['customer_code'] = 'KH0' . ($max_code);
            else if ($max_code < 1000000)
                $data['customer_code'] = 'KH' . ($max_code);

            $this->db->insert('customers', $data);
            $id = $this->db->insert_id();

            if($total_debt !='' && $total_debt>0){
                $order['lack'] = $total_debt;
                $order['user_init'] = $this->auth['id'];
                $order['store_id'] = $this->auth['store_id'];
                $order['total_price'] = $total_debt;
                $order['customer_id'] = $id;
                $order['order_status'] = 1;

                $this->db->select_max('output_code')->like('output_code', 'PX')->where('input_id', 0);
                $max_output_code = $this->db->get('orders')->row();
                $max_code = (int)(str_replace('PX', '', $max_output_code->output_code)) + 1;
                if ($max_code < 10)
                    $order['output_code'] = 'PX000000' . ($max_code);
                else if ($max_code < 100)
                    $order['output_code'] = 'PX00000' . ($max_code);
                else if ($max_code < 1000)
                    $order['output_code'] = 'PX0000' . ($max_code);
                else if ($max_code < 10000)
                    $order['output_code'] = 'PX000' . ($max_code);
                else if ($max_code < 100000)
                    $order['output_code'] = 'PX00' . ($max_code);
                else if ($max_code < 1000000)
                    $order['output_code'] = 'PX0' . ($max_code);
                else if ($max_code < 10000000)
                    $order['output_code'] = 'PX' . ($max_code);
                $this->db->insert('orders', $order);

            }

            echo $this->messages = $id;
        } else {
            $count = $this->db->where('customer_code', $data['customer_code'])->from('customers')->count_all_results();
            if ($count > 0) {
                echo $this->messages = "0";
            } else {
                $this->db->insert('customers', $data);
                $id = $this->db->insert_id();
                if($total_debt !='' && $total_debt>0){
                    $order['lack'] = $total_debt;
                    $order['user_init'] = $this->auth['id'];
                    $order['store_id'] = $this->auth['store_id'];
                    $order['total_price'] = $total_debt;
                    $order['customer_id'] = $id;
                    $order['order_status'] = 1;

                    $this->db->select_max('output_code')->like('output_code', 'PX')->where('input_id', 0);
                    $max_output_code = $this->db->get('orders')->row();
                    $max_code = (int)(str_replace('PX', '', $max_output_code->output_code)) + 1;
                    if ($max_code < 10)
                        $order['output_code'] = 'PX000000' . ($max_code);
                    else if ($max_code < 100)
                        $order['output_code'] = 'PX00000' . ($max_code);
                    else if ($max_code < 1000)
                        $order['output_code'] = 'PX0000' . ($max_code);
                    else if ($max_code < 10000)
                        $order['output_code'] = 'PX000' . ($max_code);
                    else if ($max_code < 100000)
                        $order['output_code'] = 'PX00' . ($max_code);
                    else if ($max_code < 1000000)
                        $order['output_code'] = 'PX0' . ($max_code);
                    else if ($max_code < 10000000)
                        $order['output_code'] = 'PX' . ($max_code);
                    $this->db->insert('orders', $order);

                }


                echo $this->messages = $id;
            }
        }
    }

    public function cms_delCustomer()
    {
        $id = (int)$this->input->post('id');
        $customer = $this->db->from('customers')->where('ID', $id)->get()->row_array();
        if (!isset($customer) && count($customer) == 0) {
            echo $this->messages;

            return;
        } else {
            $this->db->where('ID', $id)->delete('customers');
            echo $this->messages = '1';
        }
    }

    public function cms_edit_customer()
    {
        $id = (int)$this->input->post('id');
        $customer = $this->db->from('customers')->where('id', $id)->get()->row_array();
        if (!isset($customer) && count($customer) == 0) {
            echo $this->messages;
            return;
        } else {
            ob_start();
            $html = ob_get_contents();
            ob_end_clean();
        }
    }

    public function cms_detail_itemcust($id)
    {
        $id = (int)$id;
        $customer = $this->db->from('customers')->where('id', $id)->get()->row_array();
        if (!isset($customer) && count($customer) == 0) {
            echo $this->messages;
            return;
        } else {
            $data['_list_cus'] = $customer;
            $data['_list_cus']['customer_birthday'] = ($customer['customer_birthday'] != '1970-01-01 07:00:00') ? gmdate("d/m/Y", strtotime(str_replace('-', '/', $customer['customer_birthday'])) + 7 * 3600) : '';
            $this->load->view('ajax/customer-supplier/detail_cus', isset($data) ? $data : null);
        }
    }

    public function cms_detail_order_in_customer()
    {
        if ($this->auth == null) $this->cms_common_string->cms_redirect(CMS_BASE_URL . 'backend');
        $id = $this->input->post('id');
        $order = $this->db->from('orders')->where('ID', $id)->get()->row_array();
        $data['_list_products'] = array();

        if (isset($order) && count($order)) {
            $list_products = json_decode($order['detail_order'], true);

            foreach ($list_products as $product) {
                $_product = cms_finding_productbyID($product['id']);
                $_product['quantity'] = $product['quantity'];
                $_product['price'] = $product['price'];
                $data['_list_products'][] = $_product;
            }
        }

        $data['data']['_order'] = $order;
        $this->load->view('ajax/customer-supplier/detail_order', isset($data) ? $data : null);
    }

    public function cms_save_edit_customer($id)
    {
        $id = (int)$id;
        $data = $this->input->post('data');
        $data = $this->cms_common_string->allow_post($data, ['customer_group','customer_name', 'customer_phone', 'customer_email','customer_image', 'customer_addr', 'notes', 'customer_birthday', 'customer_gender','kho_id']);
        if($data['customer_image']=='')
            unset($data['customer_image']);

        $data['customer_birthday'] = gmdate("Y-m-d H:i:s", strtotime(str_replace('/', '-', $data['customer_birthday'])) + 7 * 3600);
        $data['updated'] = gmdate("Y:m:d H:i:s", time() + 7 * 3600);
        $data['user_upd'] = $this->auth['id'];
        $this->db->where('ID', $id)->update('customers', $data);
        echo $this->messages = '1';
    }
}